#include "util/logger.h"

#include <syslog.h>
#include <stdbool.h>
#include <stdio.h>
#include <string.h>

static logger_loglevel_t logger_min_level=LOGGER_LEVEL_ERROR;

static void logger_console_log(FILE* stream, const char *level, const char *message, va_list args);
static void logger_kmsg_log(const char *level, const char *message, va_list args);


void logger_init(logger_loglevel_t min_level)
{
	logger_min_level=min_level;
}

void logger_log_error(const char *message, ...)
{
	va_list args;
	memset(&args,0,sizeof(va_list));

	if (logger_min_level==LOGGER_LEVEL_NONE)
		return;

	va_start (args, message);
	logger_console_log(stderr,"ERROR",message,args);
	va_end(args);

	va_start (args, message);
	logger_kmsg_log("ERROR", message,args);
	va_end(args);
}

void logger_vlog_error(const char *fmt, va_list args)
{
	va_list args_cpy;
	memset(&args_cpy,0,sizeof(va_list));
	va_copy(args_cpy,args);
	logger_console_log(stderr,"ERROR",fmt,args);
	logger_kmsg_log("ERROR", fmt,args_cpy);
}

void logger_log_info(const char *message, ...)
{
	va_list args;
	memset(&args,0,sizeof(va_list));

	if (logger_min_level<LOGGER_LEVEL_INFO)
		return;

	va_start (args, message);
	logger_console_log(stdout,"INFO",message,args);
	va_end(args);

	va_start (args, message);
	logger_kmsg_log("INFO", message,args);
	va_end(args);
}

void logger_vlog_info(const char *fmt, va_list args)
{
	va_list args_cpy;
	memset(&args_cpy,0,sizeof(va_list));
	va_copy(args_cpy,args);
	logger_console_log(stdout,"INFO",fmt,args);
	logger_kmsg_log("INFO", fmt,args_cpy);
}

void logger_log_debug(const char *message, ...)
{
	va_list args;
	memset(&args,0,sizeof(va_list));

	if (logger_min_level<LOGGER_LEVEL_DEBUG)
		return;

	va_start(args, message);
	logger_console_log(stdout,"DEBUG",message,args);
	va_end(args);

	va_start (args, message);
	logger_kmsg_log("DEBUG", message,args);
	va_end(args);
}

void logger_vlog_debug(const char *fmt, va_list args)
{
	va_list args_cpy;
	memset(&args_cpy,0,sizeof(va_list));
	va_copy(args_cpy,args);
	logger_console_log(stdout,"DEBUG",fmt,args);
	logger_kmsg_log("DEBUG", fmt,args_cpy);
}

static void logger_console_log(FILE* stream, const char *level, const char *message, va_list args)
{

	if (level!=NULL)
		fprintf(stream,"%s: ",level);
	vfprintf(stream, message, args);
	fprintf(stream, "\n");
}

static void logger_kmsg_log(const char *level, const char *message, va_list args)
{
	FILE *kmsg_fd=NULL;
	kmsg_fd=fopen("/dev/kmsg","w");
	if (kmsg_fd!=NULL)
	{
		logger_console_log(kmsg_fd,level,message,args);
		fclose(kmsg_fd);
	}
}
